/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class LocalNaming
extends OiifpWizPanel
implements ActionListener,
ItemListener {
    private LWCheckbox yesCheck;
    private LWCheckbox noCheck;
    private LWCheckboxGroup radioGroup = new LWCheckboxGroup();
    private Button browseButton;
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String DEFAULT_CHOICE1 = "Yes, ...";
    private static final String DEFAULT_CHOICE2 = "No, ...";
    private MultiLineLabel promptLabel;
    private LWTextField textField;
    private Color promptLabelColor;
    private Color textFieldColor;
    private Container frame;
    private OiipgFileSystem oifSys;
    private DirectoryDrive[] directoryDrive;
    private int yesSelected = 1;

    public LocalNaming() {
        this("", "", DEFAULT_CHOICE1, DEFAULT_CHOICE2);
        this.setTitleLabel(DEFAULT_TITLE);
        this.setPrompt(DEFAULT_PROMPT);
        this.setDefaultPath("");
    }

    public LocalNaming(String promptString, String defaultPath, String choice1, String choice2) {
        super(DEFAULT_TITLE);
        GridBagLayout gridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 2;
        this.promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.gridwidth = 0;
        gridbag.setConstraints((Component)this.promptLabel, c);
        this.mainPanel.add((Component)this.promptLabel);
        c.gridwidth = 0;
        this.yesCheck = new LWCheckbox(choice1, this.radioGroup, true);
        this.yesCheck.addItemListener((ItemListener)this);
        gridbag.setConstraints((Component)this.yesCheck, c);
        this.mainPanel.add((Component)this.yesCheck);
        this.textField = new LWTextField(defaultPath);
        c.gridwidth = -1;
        gridbag.setConstraints((Component)this.textField, c);
        this.mainPanel.add((Component)this.textField);
        this.browseButton = new Button("Browse");
        this.browseButton.addActionListener(this);
        c.gridwidth = 0;
        c.fill = 3;
        c.gridx = -1;
        gridbag.setConstraints(this.browseButton, c);
        this.mainPanel.add((Component)this.browseButton);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.noCheck = new LWCheckbox(choice2, this.radioGroup, false);
        this.noCheck.addItemListener((ItemListener)this);
        gridbag.setConstraints((Component)this.noCheck, c);
        this.mainPanel.add((Component)this.noCheck);
        this.promptLabelColor = this.promptLabel.getBackground();
        this.textFieldColor = this.textField.getBackground();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            this.frame = this;
            this.oifSys = new OiipgFileSystem();
            this.directoryDrive = this.oifSys.getDirectoryDrives();
            this.yesCheck.setState(true);
            this.noCheck.setState(false);
            while (!(this.frame instanceof Frame)) {
                this.frame = this.frame.getParent();
            }
            DirectoryDialog fd = new DirectoryDialog((Frame)this.frame, "Directory Dialog");
            fd.setDrives(this.directoryDrive);
            File loc = new File(this.textField.getText());
            File file = fd.runDialog(loc);
            if (file != null) {
                this.setDirectory(file.getPath());
            } else {
                loc = new File(System.getProperty("user.dir"));
                file = fd.runDialog(loc);
                if (file != null) {
                    this.setDirectory(file.getPath());
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.yesCheck) {
            this.yesSelected = 1;
            this.browseButton.setEnabled(true);
            this.textField.setEnabled(true);
        }
        if (source == this.noCheck) {
            this.yesSelected = 0;
            this.browseButton.setEnabled(false);
            this.textField.setEnabled(false);
        }
    }

    public void setDefaultPath(String defaultPath) {
        this.textField.setText(defaultPath);
    }

    public String getPrompt() {
        return this.promptLabel.getText();
    }

    public void setPrompt(String text) {
        if (text != null) {
            this.promptLabel.setText(text);
        }
    }

    public String[] getDirectory() {
        String[] retVal = new String[2];
        if (this.yesSelected == 1) {
            retVal[0] = "YES";
            retVal[1] = this.textField.getText();
        } else {
            retVal[0] = "NO";
            retVal[1] = "";
        }
        return retVal;
    }

    public void setDirectory(String text) {
        if (text != null) {
            this.textField.setText(text);
        }
    }

    public String getChoice1() {
        return this.yesCheck.getLabel();
    }

    public void setChoice1(String text) {
        if (text != null) {
            this.yesCheck.setLabel(text);
        }
    }

    public String getChoice2() {
        return this.noCheck.getLabel();
    }

    public void setChoice2(String text) {
        if (text != null) {
            this.noCheck.setLabel(text);
        }
    }

    public void markPrompt() {
        this.promptLabel.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this.promptLabel.setBackground(this.promptLabelColor);
    }

    public void markDirectory() {
        this.textField.setBackground(this._markColor);
    }

    public void unmarkDirectory() {
        this.textField.setBackground(this.textFieldColor);
    }

    public void markChoice1() {
        this.yesCheck.setBackground(this._markColor);
    }

    public void unmarkChoice1() {
        this.yesCheck.setBackground(this.textFieldColor);
    }

    public void markChoice2() {
        this.noCheck.setBackground(this._markColor);
    }

    public void unmarkChoice2() {
        this.noCheck.setBackground(this.textFieldColor);
    }
}

